/*
 *
 * Komunikacja midzy oknem potomnym a macierzystym
 *
 */
#include <windows.h>
#include <stdio.h>

/* Deklaracja wyprzedzajca: funkcja obsugi okna */
LRESULT CALLBACK WindowProcedure(HWND, UINT, WPARAM, LPARAM);
/* Nazwa klasy okna */
char szClassName[] = "PRZYKLAD";
/* ID przycisku */
const int ID_BUTTON1 = 100;
const int ID_BUTTON2 = 101;

int WINAPI WinMain(HINSTANCE hInstance, 
                   HINSTANCE hPrevInstance, 
                   LPSTR lpCmdLine, 
                   int nShowCmd)
{
    HWND hwnd;               /* Uchwyt okna */
    MSG messages;            /* Komunikaty okna */
    WNDCLASSEX wincl;        /* Struktura klasy okna */

    /* Klasa okna */
    wincl.hInstance     = hInstance;
    wincl.lpszClassName = szClassName;
    wincl.lpfnWndProc   = WindowProcedure;    // wskanik na funkcj 
                                              // obsugi okna  
    wincl.style         = CS_DBLCLKS;                 
    wincl.cbSize        = sizeof(WNDCLASSEX);

    /* Domylna ikona i wskanik myszy */
    wincl.hIcon   = LoadIcon(NULL, IDI_APPLICATION);
    wincl.hIconSm = LoadIcon(NULL, IDI_APPLICATION);
    wincl.hCursor = LoadCursor(NULL, IDC_ARROW);
    wincl.lpszMenuName = NULL; 
    wincl.cbClsExtra = 0;   
    wincl.cbWndExtra = 0;   
    /* Jasnoszare to */
    wincl.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);

    /* Rejestruj klas okna */
    if(!RegisterClassEx(&wincl)) return 0;

    /* Twrz okno */
    hwnd = CreateWindowEx(
           0, szClassName,         
           "Przykad",       
           WS_OVERLAPPEDWINDOW, 
           CW_USEDEFAULT, CW_USEDEFAULT,       
           512, 512,                 
           HWND_DESKTOP, NULL,                
           hInstance, NULL );

    ShowWindow(hwnd, nShowCmd);
    /* Ptla obsugi komunikatw */
    while(GetMessage(&messages, NULL, 0, 0))
    {
           /* Tumacz kody rozszerzone */
           TranslateMessage(&messages);
           /* Obsu komunikat */
           DispatchMessage(&messages);
    }

    /* Zwr parametr podany w PostQuitMessage( ) */
    return messages.wParam;
}

/* T funkcj woa DispatchMessage( ) */
LRESULT CALLBACK WindowProcedure(HWND hwnd, UINT message, 
                                 WPARAM wParam, LPARAM lParam)
{
    HWND hButton1, hButton2;
    switch (message)                  
    {
           case WM_CREATE:
              hButton1 = CreateWindow( "BUTTON", "Przycisk 1",
                                   WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
                                   10, 10, 200, 32, 
                                   hwnd, (HMENU) ID_BUTTON1,
                                   ((LPCREATESTRUCT) lParam)->hInstance, 
                                   NULL) ;
              hButton2 = CreateWindow( "BUTTON", "Przycisk 2",
                                   WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
                                   10, 50, 200, 32, 
                                   hwnd, (HMENU) ID_BUTTON2,
                                   ((LPCREATESTRUCT) lParam)->hInstance, 
                                   NULL) ;

              break;
           case WM_COMMAND: 
              // jeli kliknito przycisk
              if ( HIWORD(wParam) == BN_CLICKED ) 
              {
                 switch( LOWORD(wParam) )
                 { 
                    case ID_BUTTON1 : MessageBox( hwnd, 
                                                  "Wcinito przycisk 1", 
                                                  "", MB_OK ); break;
                    case ID_BUTTON2 : MessageBox( hwnd, 
                                                  "Wcinito przycisk 2", 
                                                  "", MB_OK ); break;
                 } 
              }
              break;
           case WM_DESTROY:
              PostQuitMessage(0);        
              break;
           default:                   
              return DefWindowProc(hwnd, message, wParam, lParam);        
    }              
    return 0;
}
